<?LassoScript //[

// #################################################################################
//
// Location: /hostedstore/includes/calculations/calculate_shipping.lasso
//
// Purpose: This file calculates the shipping cost for items in the shopping cart
//          for the cart display page and the order review page.
// 
// History: 2002.02.02 BKM Converted to LassoScript and commented code.
//
// Variables: Each variable is briefly described below along with its type.
//
//            HS_ShippingQuantityRate - Decimal
//            Sets the price for quantity based shipping. This variable is set
//            in the site parameters file located at:
//            /hostedstore/includes/HS_siteparameters.lasso
//
//            HSP_ItemShippingType - String
//            The shipping type for the item as set in the ShippingType field
//            for the product.
//
//            HSP_ItemShippingValue - Decimal
//            The shipping value for the item as set in the ShipingValue field
//            for the product.
//
//            HSP_ItemQuantity - Integer
//            The quantity of the item in the cart/order.
//
//            HSP_CartShippingCost - Decimal
//            The cumulative cost of shipping all items in the cart.  The cost
//            of shipping each item should be added to this variable.
// 
// Input: HS_ShippingQuantityRate
//        HSP_ItemShippingType
//        HSP_ItemShippingValue
//        HSP_ItemQuantity
//        HSP_ShippingCity
//        HSP_ShippingState
//        HSP_ShippingCountry
//        HSP_ShippingPostal
//        HSP_BillingCity
//        HSP_BillingState
//        HSP_BillingCountry
//        HSP_BillingPostal
//
// Output: HSP_CartShippingCost
//
// Example scripts:
//
//
//
//
//
//
//
//
//
//
//
// #################################################################################

If:$HSP_ItemShippingType=='Fixed';
 $HSP_CartShippingCost+=($HSP_ItemQuantity
                        *$HSP_ItemShippingValue);
Else:$HSP_ItemShippingType=='Quantity';
 $HSP_CartShippingCost+=($HSP_ItemQuantity
                        *$HSP_ItemShippingValue
                        *$HS_ShippingQuantityRate);
Else:$HSP_ItemShippingType=='Weight';
 If:$HSP_ItemShippingValue<=25.00;
  $HSP_CartShippingCost+=($HSP_ItemQuantity
                         *15.00);
 Else:$HSP_ItemShippingValue<=50.00;
		$HSP_CartShippingCost+=($HSP_ItemQuantity
																					   	*20.00);
 Else:$HSP_ItemShippingValue<=100.00;
		$HSP_CartShippingCost+=($HSP_ItemQuantity
																						   *25.00);
 Else;
		$HSP_CartShippingCost+=($HSP_ItemQuantity
																 					  	*50.00);
 /If;
/If;

?>