<?LassoScript //[

// #################################################################################
//
// Location: /hostedstore/includes/calculations/calculate_tax.lasso
//
// Purpose: This file calculates the tax for an order during checkout when the
//          shipping state is known or during the cart process when the shipping
//          state is not known.
// 
// History: 2002.07.16 BKM Added conditional statment to bypass tax caluclation
//                         if the customer belongs to a tax exempt price group.
//          2002.02.02 BKM Converted to LassoScript and commented code.
//
// Variables: Each variable is briefly described below along with its type.
//
//            HS_TaxableStates - String
//            States that are taxable delimited by || characters.
//            This variable is set in the site parameters file located at:
//            /hostedstore/includes/HS_siteparameters.lasso
//
//            HS_TaxableStatesRates - String
//            Tax rates for taxable states delimited by || characters.
//            This variable is set in the site parameters file located at:
//            /hostedstore/includes/HS_siteparameters.lasso
//
//            HSP_ShippingState - String
//            The state to which the order is to be shipped.  This variable will
//            only have a value if the customer is in the checkout process.
//
//            HSP_CartSubTotal - Decimal
//            The price subtotal of all items in the shopping cart.
//
//            HSP_CartShippingCost - Decimal
//            The cumulative cost of shipping all items in the cart as calculated
//            by the script located at:
//            /hostedstore/includes/calculations/calculate_shipping.lasso
//
//            HSP_CartTaxableTotal - Decimal
//            The price subtotal of all items in the shopping cart taht have been
//            configured as taxable.
//
//            HSP_TaxableStates - Array
//            An array build from HS_TaxableStates.
//
//            HSP_TaxableStatesRates - Array
//            An array build from HS_TaxableStatesRates.
//
//            HSP_TempTaxRate - Decimal
//            The tax rate for an individual state.
//
//            HSP_TempTax - Decimal
//            The calculated tax for an individual state.
//
//            HSP_TempTotalWithTax - Decimal
//            The calculated order total with tax and shipping for an
//            individual state.
//
//            HSP_CartTax - Decimal
//            The calculated tax when HSP_ShippingState is known.
//
//            HSP_CartTaxValues - Array
//            The state name, tax, and order total with shipping and tax for
//            each taxable state when HSP_ShippingState is not known.
//
//            HSP_PriceGroupTaxExempt - String
//            Has a value of Y if the customer belongs to a tax exempt price group.
//
// Input: HS_TaxableStates
//        HS_TaxableStatesRates
//        HSP_ShippingState
//        HSP_CartSubTotal
//        HSP_CartShippingCost
//        HSP_CartTaxableTotal
//        HSP_PriceGroupTaxExempt
//
// Output: HSP_CartTax if HSP_ShippingState is known.
//         HSP_CartTaxValues if HSP_ShippingState is not known.
//
// #################################################################################

// Declare variables.
Var:'HSP_TempTaxRate'=Decimal,
				'HSP_TempTax'=Decimal,
				'HSP_TempTotalWithTax'=Decimal,
				'HSP_CartTax'=Decimal,
				'HSP_CartTaxValues'=Array,
				'HSP_TaxableStates'=Array,
				'HSP_TaxableStatesRates'=Array;

If:(Var:'HSP_PriceGroupTaxExempt')!='Y';
// Build array of taxable shipping states if necessary.
	If:$HS_TaxableStates;
		$HSP_TaxableStates=$HS_TaxableStates->(Split:'||');
	/If;
// Build array of tax rates.
	$HSP_TaxableStatesRates=$HS_TaxableStatesRates->(Split:'||');
	
// If shipping is taxable, add shipping to the taxable total.
	If:$HS_TaxShipping=='Y';
  $HSP_CartShippingCost->(SetFormat:-Precision=$HS_CurrencyPrecision);
		$HSP_CartTaxableTotal+=(Decimal:(String:$HSP_CartShippingCost));
 /If;
	
// Calculate tax(es).
	If:$HSP_ShippingState;
	
// #################################################################################
//
// Shipping state is known.
// Calculate tax for that state only.
//
// #################################################################################
	
// Loop through taxable states to find the matching state.
		Loop:($HSP_TaxableStates->(Size));
			If:$HSP_ShippingState==($HSP_TaxableStates->(Get:Loop_Count));
// This is the matching state.
// Get the tax rate.
				$HSP_TempTaxRate=($HSP_TaxableStatesRates->(Get:Loop_Count));
				Loop_Abort;
			/If;
		/Loop;
// Calculate tax.
		$HSP_CartTax=$HSP_CartTaxableTotal
														*$HSP_TempTaxRate;
	Else;
	
// #################################################################################
//
// Shipping state is not known.
// Calculate tax for all taxable states.
//
// #################################################################################

// Loop through all taxable states.
		Loop:($HSP_TaxableStates->(Size));
// Get tax rate.
			$HSP_TempTaxRate=($HSP_TaxableStatesRates->(Get:Loop_Count));
// Calculate tax.
			$HSP_TempTax=$HSP_CartTaxableTotal
															*$HSP_TempTaxRate;
// Set display formatting.
   $HSP_CartSubTotal->(SetFormat:-Precision=$HS_CurrencyPrecision);
   $HSP_CartShippingCost->(SetFormat:-Precision=$HS_CurrencyPrecision);
   $HSP_TempTax->(SetFormat:-Precision=$HS_CurrencyPrecision);
// Calculate order total with tax and shipping.
			$HSP_TempTotalWithTax=(Decimal:(String:$HSP_CartSubTotal))
																								+(Decimal:(String:$HSP_CartShippingCost))
																								+(Decimal:(String:$HSP_TempTax));		
// Format monetary values.
			$HSP_TempTax=(HS_FormatCurrency:$HSP_TempTax);
			$HSP_TempTotalWithTax=(HS_FormatCurrency:$HSP_TempTotalWithTax);		
// Populate HSP_CartTaxValues.
// Insert an array containing the name of the state, the tax, and the order total.
			$HSP_CartTaxValues->(Insert:(Array:($HSP_TaxableStates->(Get:Loop_Count)),
																								 													$HSP_TempTax,
																									 												$HSP_TempTotalWithTax));
		/Loop;
	/If;
/If;

?>